


/***********************************************************************************************
 *                                                                                             *
 *                   Example_1. ET-REMOTE MP3 COMMAND-Mode By Sent Command                     *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722(ICD2))                                      *
 *                   : X-TAL : 10 MHz                                                          *
 *                   : CPU Clock = 40 MHz (x4)                                                 *                                                                  
 * Editor-Compiler   : CCS Version 4.120                                                       *
 *                                                                                             *
 *                                                                                             *
 * Port Interface    :  # MCU-18F8722 #                        # ET-REMOTE MP3 #               *
 *                      --------------                        -------------------              * 
 *                                                                                             *
 *       UART1       :  PORT RC6 = TX1          Connect              Tx                        *
 *                      PORT RC7 = RX1          Connect              Rx                        *
 *                      GND                     Connect              GND                       *
 *                      Baud Rate 9600                                                         *
 *                                                                                             *
 *                                                                                             *
  *              5V                                                                            *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIF SW.MODE         *
 *              |                  |                                       S1=ON,S2=ON         *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON,S2=OFF       *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX1   |       |   |   |   |----+              |                       *
 *       |          RC7+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX1   |       |   | |     |   ||              |      /  |             *
 *       |          RC6+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       | PIC18F8722  |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have number File 15 File           *
 *                   Play File Numbe 1 once and Play Repeat File Number 2-15                   *
 *                                                                                             *
 * Last Update     : 28/June/2012                                                              *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/



#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
#use rs232(baud = 9600, xmit = TX1, rcv = RX1)   //Set Rs232

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


int8  num_hi,num_lo  ;                           //Keep Ascii byte high and low

/*****************************************
 **       Function Initial UART1        **
 *****************************************/

void UART1_Init(void)
 {
   set_tris_C(0x80)             ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out

 }

//---------- Check Respond Command & End of Fili From Board MP3 -----------------
 

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm(void)
 {
   int8 buf_cmm[2] ;
   int8 n,ch ;
   
   do
    {
      do
       {
        ch = getc()                              ; //Read data Start Byte
       }while(ch != '#')                         ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                             //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         buf_cmm[n] = getc()                     ; //Read Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }


//-------------- Check Echo End Of File(&E) ---------------

void Echo_EOF(void)
 {
   
   int8 eof,ch ;
   
   do
    {
      do
       {
         ch = getc()                           ; //Read Data
       }while(ch != '&')                       ; //Check Byte Start of Echo EOF('&')

       eof = getc()                            ; //Read Data 
            
    }while(eof!='E')                           ;  //Check Echo EOF = 'E' Exit loop
 }


//--------------- Convert Dec(01-99) To Ascii 2 Colume  --------------------

void Dec_to_Ascii(int8 num_fi)
 {
   if(num_fi <= 99)
    {
      num_hi = (num_fi/10)+0x30   ; //Convert to Ascii Byte High
      num_lo = (num_fi%10)+0x30   ; //Convert to Ascii Byte Low 
    }
 }

/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void) 
  {
    int8 num,enter  = 0x0D  ;

    UART1_Init()      ;
    delay_ms(2000)    ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

    printf("*CF=000%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,0:Not Display Time
    Echo_Cmm()                     ;   //Check CMM'#OK'
  
    printf("*VL=60%c",enter)       ;   //Sent CMM Set Volum='60'
    Echo_Cmm()                     ;   //Check CMM'#OK'

    printf("*P1=01%c",enter)       ;   //Sent CMM Play File by Number :Start File #1
    Echo_Cmm()                     ;   //Check CMM'#OK'
    Echo_EOF()                     ;   //Check End of File
    

   //------------- Loop Play file Number #2-#15 Repeat All  -----------
    
   num = 2 ;
   while(true)
     {
      Dec_to_Ascii(num)                         ;   //Convert Number File to Ascii
      printf("*P1=%c%c%c",num_hi,num_lo,enter)  ;   //Sent CMM Play File by Number :Start File #2
      Echo_Cmm()                                ;   //Check CMM'#OK'
      Echo_EOF()                                ;   //Check End of File
      num = num+1                               ;   //Increment Next Number File
 
      if(num==16)                                   //Check File Last number 15
       num = 2                                  ;   //New Start File Number 2 
     }    
 
  }


















